% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/string.R
\name{check_string}
\alias{check_string}
\title{Check String}
\usage{
check_string(x, coerce = FALSE, x_name = substitute(x), error = TRUE)
}
\arguments{
\item{x}{The object to check.}

\item{coerce}{A flag indicating whether to coerce a factor scalar to a string.}

\item{x_name}{A string of the name of the object.}

\item{error}{A flag indicating whether to throw an informative error or immediately generate an informative message if the check fails.}
}
\value{
An invisible copy of x (if it doesn't throw an error).
}
\description{
Checks if object is a string (non-missing character scalar or if \code{coerce = TRUE} a non-missing factor scalar).
}
\examples{
check_string(1, error = FALSE)
check_string("1", error = FALSE)
check_string(c("1", "2"), error = FALSE)
}
\seealso{
\code{\link{check_scalar}}
}
