% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkDataTable.R
\name{checkDataTable}
\alias{assertDataTable}
\alias{assert_data_table}
\alias{checkDataTable}
\alias{expect_data_table}
\alias{testDataTable}
\alias{test_data_table}
\title{Check if an argument is a data table}
\usage{
checkDataTable(x, key = NULL, index = NULL, types = character(0L),
  any.missing = TRUE, all.missing = TRUE, min.rows = NULL,
  min.cols = NULL, nrows = NULL, ncols = NULL, row.names = NULL,
  col.names = NULL)

assertDataTable(x, key = NULL, index = NULL, types = character(0L),
  any.missing = TRUE, all.missing = TRUE, min.rows = NULL,
  min.cols = NULL, nrows = NULL, ncols = NULL, row.names = NULL,
  col.names = NULL, .var.name = vname(x), add = NULL)

assert_data_table(x, key = NULL, index = NULL, types = character(0L),
  any.missing = TRUE, all.missing = TRUE, min.rows = NULL,
  min.cols = NULL, nrows = NULL, ncols = NULL, row.names = NULL,
  col.names = NULL, .var.name = vname(x), add = NULL)

testDataTable(x, key = NULL, index = NULL, types = character(0L),
  any.missing = TRUE, all.missing = TRUE, min.rows = NULL,
  min.cols = NULL, nrows = NULL, ncols = NULL, row.names = NULL,
  col.names = NULL)

test_data_table(x, key = NULL, index = NULL, types = character(0L),
  any.missing = TRUE, all.missing = TRUE, min.rows = NULL,
  min.cols = NULL, nrows = NULL, ncols = NULL, row.names = NULL,
  col.names = NULL)

expect_data_table(x, key = NULL, index = NULL, types = character(0L),
  any.missing = TRUE, all.missing = TRUE, min.rows = NULL,
  min.cols = NULL, nrows = NULL, ncols = NULL, row.names = NULL,
  col.names = NULL, info = NULL, label = vname(x))
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{key}{[\code{character}]\cr
Expected primary key(s) of the data table.}

\item{index}{[\code{character}]\cr
Expected secondary key(s) of the data table.}

\item{types}{[\code{character}]\cr
Character vector of class names. Each list element must inherit
from at least one of the provided types.
The types \dQuote{logical}, \dQuote{integer}, \dQuote{integerish}, \dQuote{double},
\dQuote{numeric}, \dQuote{complex}, \dQuote{character}, \dQuote{factor}, \dQuote{atomic}, \dQuote{vector}
\dQuote{atomicvector}, \dQuote{array}, \dQuote{matrix}, \dQuote{list}, \dQuote{function},
\dQuote{environment} and \dQuote{null} are supported.
For other types \code{\link[base]{inherits}} is used as a fallback to check \code{x}'s inheritance.
Defaults to \code{character(0)} (no check).}

\item{any.missing}{[\code{logical(1)}]\cr
Are missing values allowed? Default is \code{TRUE}.}

\item{all.missing}{[\code{logical(1)}]\cr
Are matrices with only missing values allowed? Default is \code{TRUE}.}

\item{min.rows}{[\code{integer(1)}]\cr
Minimum number of rows.}

\item{min.cols}{[\code{integer(1)}]\cr
Minimum number of columns.}

\item{nrows}{[\code{integer(1)}]\cr
Exact number of rows.}

\item{ncols}{[\code{integer(1)}]\cr
Exact number of columns.}

\item{row.names}{[\code{character(1)}]\cr
Check for row names. Default is \dQuote{NULL} (no check).
See \code{\link{checkNamed}} for possible values.
Note that you can use \code{\link{checkSubset}} to check for a specific set of names.}

\item{col.names}{[\code{character(1)}]\cr
Check for column names. Default is \dQuote{NULL} (no check).
See \code{\link{checkNamed}} for possible values.
Note that you can use \code{\link{checkSubset}} to test for a specific set of names.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link{vname}}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link{AssertCollection}}.}

\item{info}{[character(1)]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[\code{character(1)}]\cr
Name of the checked object to print in messages. Defaults to
the heuristic implemented in \code{\link{vname}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions return \code{TRUE}. If the check
 is not successful, \code{assertDataTable}/\code{assert_data_table}
 throws an error message, \code{testDataTable}/\code{test_data_table}
 returns \code{FALSE},
 and \code{checkDataTable} returns a string with the error message.
 The function \code{expect_data_table} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Check if an argument is a data table
}
\examples{
library(data.table)
dt = as.data.table(iris)
setkeyv(dt, "Species")
setkeyv(dt, "Sepal.Length", physical = FALSE)
testDataTable(dt)
testDataTable(dt, key = "Species", index = "Sepal.Length", any.missing = FALSE)
}
\seealso{
Other basetypes: \code{\link{checkArray}},
  \code{\link{checkAtomic}}, \code{\link{checkCharacter}},
  \code{\link{checkComplex}}, \code{\link{checkDataFrame}},
  \code{\link{checkEnvironment}},
  \code{\link{checkFactor}}, \code{\link{checkFunction}},
  \code{\link{checkIntegerish}},
  \code{\link{checkInteger}}, \code{\link{checkList}},
  \code{\link{checkLogical}}, \code{\link{checkMatrix}},
  \code{\link{checkNumeric}}, \code{\link{checkVector}}
}

