% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkScalarNA.r
\name{checkScalarNA}
\alias{assertScalarNA}
\alias{assert_scalar_na}
\alias{checkScalarNA}
\alias{expect_scalar_na}
\alias{testScalarNA}
\alias{test_scalar_na}
\title{Check if an argument is a single missing value}
\usage{
checkScalarNA(x)

assertScalarNA(x, add = NULL, .var.name)

assert_scalar_na(x, add = NULL, .var.name)

testScalarNA(x)

test_scalar_na(x)

expect_scalar_na(x, info = NULL, label = NULL)
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertions. See \code{\link{AssertCollection}}.}

\item{.var.name}{[character(1)]\cr
Name for \code{x}. Defaults to a heuristic to determine
the name using \code{\link[base]{deparse}} and \code{\link[base]{substitute}}.}

\item{info}{[character(1)]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[character(1)]\cr
Same as \code{.var.name}, but passed down to \code{\link[testthat]{expect_that}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions return \code{TRUE}. If the check
 is not successful, \code{assertScalarNA}/\code{assert_scalar_na}
 throws an error message, \code{testScalarNA}/\code{test_scalar_na}
 returns \code{FALSE},
 and \code{checkScalarNA} returns a string with the error message.
 The function \code{expect_scalar_na} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Check if an argument is a single missing value
}
\examples{
testScalarNA(1)
testScalarNA(NA_real_)
testScalarNA(rep(NA, 2))
}
\seealso{
Other scalars: \code{\link{checkCount}},
  \code{\link{checkFlag}}, \code{\link{checkInt}},
  \code{\link{checkNumber}}, \code{\link{checkScalar}},
  \code{\link{checkString}}
}

