% Generated by roxygen2 (4.0.2): do not edit by hand
\name{allMissing}
\alias{allMissing}
\alias{anyMissing}
\title{Check if an object contains missing values}
\usage{
allMissing(x)

anyMissing(x)
}
\arguments{
\item{x}{[\code{ANY}]\cr
Object to check.}
}
\value{
[\code{logical(1)}] Returns \code{TRUE} if any (\code{anyMissing}) or all (\code{allMissing})
 elements of \code{x} are missing (see details), \code{FALSE} otherwise.
}
\description{
Supported are atomic types (see \code{\link[base]{is.atomic}}), lists and data frames.
Missingness is defined as \code{NA} or \code{NaN} for atomic types and data frame columns,
\code{NULL} is defined as missing for lists.
}
\examples{
allMissing(1:2)
allMissing(c(1, NA))
allMissing(c(NA, NA))
anyMissing(c(1, 1))
anyMissing(c(1, NA))
anyMissing(list(1, NULL))
}

