% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lists.R
\name{lengths_}
\alias{lengths_}
\alias{unlisted_length}
\alias{new_list}
\title{List utilities}
\usage{
lengths_(x)

unlisted_length(x)

new_list(length = 0L, default = NULL)
}
\arguments{
\item{x}{A list.}

\item{length}{Length of list.}

\item{default}{Default value for each list element.}
}
\value{
\code{lengths_()} returns the list lengths. \cr
\code{unlisted_length()} is an alternative to \code{length(unlist(x))}. \cr
\code{new_list()} is like \code{vector("list", length)} but also allows you to specify
a default value for each list element. This can be useful for
initialising with a catch-all value so that when you unlist you're guaranteed
a list of length >= to the specified length.
}
\description{
Functions to help work with lists.
}
\examples{
library(cheapr)
l <- list(1:10,
          NULL,
          list(integer(), NA_integer_, 2:10))

lengths_(l) # Faster lengths()
unlisted_length(l) # length of vector if we unlist
paste0("length: ", length(print(unlist(l))))

unlisted_length(l) - num_na(l) # Number of non-NA elements

# We can create and initialise a new list with a default value
l <- new_list(20, 0L)
l[1:5]
# This works well with vctrs_list_of objects
vctrs::new_list_of(l, ptype = integer())[1:5]
}
