% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rank_one}
\alias{rank_one}
\title{Rank one update single change-point estimation.}
\usage{
rank_one(data, theta_init, buff = 10L, regularizer = 1, tau = -1L,
  max_iter = 25L, update_w = 1, update_change = 0.9, mapping_iter = 1L,
  tol = 1e-05)
}
\arguments{
\item{data}{N x P Matrix corresponding to the raw data.}

\item{theta_init}{Initial value for theta estimate.}

\item{buff}{Distance to maintain from edge of sample.}

\item{regularizer}{Regularizing constant, lambda.}

\item{tau}{Initial Estimate for change-point.}

\item{max_iter}{Maximum number of rank-one updates to be
run.}

\item{update_w}{Step size for prox-gradient.}

\item{update_change}{Proportion of \code{update_w} to keep when
the algorithm fails to successfully estimate theta.}

\item{mapping_iter}{Number of mapping iterations.}

\item{tol}{Tolerance at which the algorithm stops running.}
}
\value{
List containing the estimated change-point and
        theta values.
}
\description{
This is a method for estimating a single-changepoint
             which takes advantage of the special structure
             of the Gaussian graphical model.  It cannot take
             arbitrary black-box models like \code{simulated_annealing}
             or \code{brute_force}.  However, it can still be run within
             \code{binary_segmentation}.
}
\author{
\packageMaintainer{changepointsHD}
}
