\name{prepare.progdismodel}
\alias{prepare.progdismodel}

\title{Prepare the data and the model for progdismodel}

\description{
Prepare the model and the data as the ones generated by \code{\link{read.los.data}} to be passed to progdismodel().
}

\usage{
prepare.progdismodel(data)
}

\arguments{
  \item{data}{data.frame of the form data.frame(id, j.01, j.02, j.03, j.12, j.13, cens):
    \describe{
    \item{id:}{id (patient id, admision id)}      
    \item{j.01:}{observed time for jump from 0 to 1}
    \item{j.02:}{observed time for jump from 0 to 2}
    \item{j.03:}{observed time for jump from 0 to 3}
    \item{j.12:}{observed time for jump from 1 to 2}
    \item{j.13:}{observed time for jump from 1 to 3}
    \item{cens:}{censoring time (either in initial or intermediate state)}
  }
 }
}


\value{A list of:
  \item{observ}{a data.frame of the form data.frame(id, from, to, time,
    oid):
    \describe{
      \item{id:}{ id (patient id, admision id)}
      \item{from:}{ the state from where a transition occurs}
      \item{to:}{ the state to which a transition occurs}
      \item{time:}{ time of the transition}
      \item{oid:}{ the observation id}
    }
  }
  \item{model}{an object of class 'msmodel', which describes the
    progressive disability model with two transient and four absorbing states.}
}

\author{ Matthias Wangler \email{mw@imbi.uni-freiburg.de}}

\seealso{ \code{\link{prepare.los.data}},  \code{\link{read.los.data}} }

\examples{
data(los.data)
p <- prepare.progdismodel(data=los.data)
}

\keyword{datasets}
\keyword{manip}

