\name{prepare.los.data}
\alias{prepare.los.data}
\title{Prepare the data for clos}
\description{Prepare data as the ones generated by \code{\link{read.los.data}} to be passed to clos().}
\usage{prepare.los.data(x) }
\arguments{
  \item{x}{data.frame of the form data.frame(id, j.01, j.02, j.03, j.12, j.13, cens):
    \describe{
    \item{id:}{id (patient id, admision id)}      
    \item{j.01:}{observed time for jump from 0 to 1}
    \item{j.02:}{observed time for jump from 0 to 2}
    \item{j.03:}{observed time for jump from 0 to 3}
    \item{j.12:}{observed time for jump from 1 to 2}
    \item{j.13:}{observed time for jump from 1 to 3}
    \item{cens:}{censoring time (either in initial or intermediate state)}
  }
 }
}
\value{ a data.frame of the form data.frame(id, from, to, time, oid):
  \item{id:}{ id (patient id, admision id)}
  \item{from:}{ the state from where a transition occurs}
  \item{to:}{ the state to which a transition occurs}
  \item{time:}{ time of the transition}
  \item{oid:}{ the observation id}
}
\note{For bootstrap applications (see the examples to
\code{\link{clos}}), where an individual may enter the new bootstrap
data set several times, it is useful to have 'oid', which will tell
several draws of the same individual apart.
}
\author{ Matthias Wangler \email{mw@imbi.uni-freiburg.de}}
\seealso{ \code{\link{clos}},  \code{\link{read.los.data}} }
\examples{
data(los.data)
my.observ <- prepare.los.data(x=los.data)
}

\keyword{datasets}
\keyword{manip}
