% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chameleon.R
\name{scale_color_chameleon}
\alias{scale_color_chameleon}
\title{Setup a color scale of distinct discrete colors in ggplot2.}
\usage{
scale_color_chameleon(
  minimal_saturation = 33,
  minimal_lightness = 20,
  maximal_lightness = 80,
  ...
)
}
\arguments{
\item{minimal_saturation}{Exclude colors whose saturation (\code{hypot(a, b)} in CIELAB color
space) is less than this value (by default, 33).}

\item{minimal_lightness}{Exclude colors whose lightnes (\code{l} in CIELAB color space) is less
than this value (by default, 20).}

\item{maximal_lightness}{Exclude colors whose lightnes (\code{l} in CIELAB color space) is more
than this value (by default, 80).}

\item{...}{Additional parameters for \code{discrete_scale}.}
}
\description{
This is a thin wrapper to \code{ggplot2::discrete_scale('colour', 'chameleon', ...)}, which uses
the colors chosen by invoking \code{distinct_colors}. The order of the colors is arbitrary. If
the data has some structure the colors should reflect, use one of the many palettes available in
R, or using \code{data_colors} for automatically matching the colors to the structure of
multi-dimensional data.
}
\examples{
library(ggplot2)
data(pbmc)
frame <- as.data.frame(pbmc$umap)
frame$type <- pbmc$types
ggplot(frame, aes(x=xs, y=ys, color=type)) +
    geom_point(size=0.75) +
    scale_color_chameleon() +
    theme(legend.text=element_text(size=12), legend.key.height=unit(14, 'pt'))
}
