% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bercusum.R
\name{bercusum}
\alias{bercusum}
\title{Risk-adjusted Bernoulli CUSUM}
\usage{
bercusum(data, followup, glmmod, theta, p0, p1, h, stoptime)
}
\arguments{
\item{data}{\code{data.frame} containing the following named columns:
\itemize{
\item \code{entrytime} numeric - time of entry into study,
\item \code{survtime} numeric - time from entry until event,
\item \code{censorid} integer - (optional) censoring indicator (0 = right censored, 1 = observed),
}}

\item{followup}{The followup time for every individual. At what time after entry do we consider the outcome?}

\item{glmmod}{Generalized linear regression model used for risk-adjustment as produced by
the function \code{\link[stats:glm]{glm}}. Standard practice: \cr
\code{glm(as.formula(paste("(survtime <= followup) & (censorid == 1)~" ,paste(covariates, collapse='+'))), data = data)}. \cr
Alternatively, a list containing:
\itemize{
\item $formula (~ covariates),
\item $coefficients (named vector specifying risk adjustment coefficients
for covariates - names must be the same as in $formula and colnames of \code{data}).
}}

\item{theta}{\eqn{e^\theta}{e^\theta} is the odds ratio under the alternative hypothesis.
Note that: \deqn{p_1 = \frac{p_0 e^\theta}{(1-p_0) (1+p_0 e^\theta)}}{p1 = (p0 * e^\theta)/((1-p0) * (1+p0 e^\theta))}}

\item{p0}{The baseline failure probability at entrytime + followup for individuals.}

\item{p1}{The alternative hypothesis failure probability at entrytime + followup for individuals.}

\item{h}{(optional) Control limit to be used for the procedure}

\item{stoptime}{(optional) Time after which the value of the chart should no longer be determined}
}
\value{
An object of class \code{bercusum} containing:
\itemize{
\item \code{CUSUM}: A \code{data.frame} containing:
\itemize{
\item $time (times at which chart is constructed),
\item $value (value of the chart at corresponding times),
\item $numobs (number of observations at corresponding times)
}
\item \code{call}: the call used to obtain output
\item \code{glmmod}: glm coefficients used for risk-adjustment, if specified
\item \code{stopind}: indicator for whether the chart was stopped by the control limit
} There are \code{\link[cgrcusum:plot.bercusum]{plot}} and
\code{\link[cgrcusum:runlength.bercusum]{runlength}} methods for "bercusum" objects.
}
\description{
This function can be used to construct a risk-adjusted Bernoulli
CUSUM chart on survival data.
Specify one of the following combinations for the parameters:
\itemize{
\item glmmod + theta
\item p0 + theta
\item p0 + p1
}
}
\details{
The Bernoulli CUSUM chart is given by:
\deqn{S_n = \max(0, S_{n-1} + W_n)}{S_n = max(0, S_{n-1} + W_n)} with
\deqn{W_n = X_n \ln \left( \frac{p_1 (1-p_0)}{p_0(1-p_1)}  \right) + \ln \left( \frac{1-p_1}{1-p_0} \right)}{W_n = X_n ln((p_1 * (1-p_0))/(p_0 * (1-p_1))) + ln((1-p_1)/(1-p_0))}
where X_n is the outcome of the n-th (chronological) subject in the data.
Instead of displaying patient numbering on the x-axis, the time of outcome is displayed.
}
\examples{
varsanalysis <- c("age", "sex", "BMI")
exprfitber <- as.formula(paste("(entrytime <= 365) & (censorid == 1)~",
 paste(varsanalysis, collapse='+')))
surgerydat$instance <- surgerydat$Hosp_num
glmmodber <- glm(exprfitber, data = surgerydat, family = binomial(link = "logit"))
bercus <- bercusum(data = subset(surgerydat, Hosp_num == 14), glmmod = glmmodber,
 followup = 100, theta = log(2))
plot(bercus)
}
\seealso{
\code{\link[cgrcusum]{plot.bercusum}}, \code{\link[cgrcusum]{runlength.bercusum}}

Other qcchart: 
\code{\link{bkcusum}()},
\code{\link{cgrcusum}()},
\code{\link{funnelplot}()}
}
\author{
Daniel Gomon
}
\concept{qcchart}
