\name{decr}

\alias{decr}

\title{Specify a Decreasing Shape-Restriction in a CGAM Formula}

\description{A symbolic routine to define that the response is decreasing in a predictor in a formula argument to cgam.}

\usage{decr(x)}

\arguments{
  \item{x}{A numeric predictor which has the same length as the response vector.}
}

\value{The vector x with a decreasing shape tag.}

\details{
  "decr" returns the vector "x" and imposes on it a shape attribute: "decreasing". According to the value of the vector itself and its shape attribute, the cone edges of the cone generated by the constraint matrix, which constrains the relationship between the response and "x" to be decreasing,  will be made. The cone edges are a set of basis employed in the hinge algorithm. 

  Note that "decr" does not make the corresponding cone edges itself. It sets things up to a subroutine called makedelta in cgam.

  See references cited in this section for more details.
}

\author{
  Mary C. Meyer and Xiyue Liao
}

\references{
  Meyer, M. C. (2013b) A simple new algorithm for quadratic programming with applications in statistics. \emph{Communications in Statistics \bold{42(5)}}, 1126--1139. 
}

\examples{
  data(cubic)

  # extract x
  x <- - cubic$x

  # extract y
  y <- cubic$y

  # regress y on x with the shape restriction: "decreasing"
  ans <- cgam(y ~ decr(x))

  # make a plot
  par(mar = c(4, 4, 1, 1))
  plot(x, y, cex = .7, xlab = "x", ylab = "y")
  lines(x, ans$muhat, col = 2)
  legend("bottomright", bty = "n", "decreasing fit", col = 2, lty = 1)

}

\seealso{
  \code{\link{decr.conc}}, \code{\link{decr.conv}}
}

\keyword{shape routine}
