% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_delay_density.R
\name{delay_density_helpers}
\alias{delay_density_helpers}
\alias{test_fn_req_args}
\alias{test_fn_num_out}
\title{Check delay density functions passed to exported functions}
\usage{
test_fn_req_args(fn, n_req_args = 1)

test_fn_num_out(fn, n = 10)
}
\arguments{
\item{fn}{A function. This is expected to be a function evaluating the
density of a distribution at numeric values, and suitable to be passed to
\code{delay_density} in \verb{cfr_*()}.}

\item{n_req_args}{The number of required arguments, i.e., arguments without
default values.}

\item{n}{The number of elements over which to evaluate the function \code{fn}.
Defaults to 10, and \code{fn} is evaluated over \code{seq(n)}.}
}
\value{
A logical for whether the function \code{fn} fulfils conditions specified
in the respective checks.
}
\description{
Internal helper function that check whether a function passed to
the \code{delay_density} argument in \verb{cfr_*()} or \code{\link[=estimate_outcomes]{estimate_outcomes()}} meet the
requirements of package methods.

\code{test_fn_req_args()} checks whether the function has only the expected number
of required arguments, i.e., arguments without default values. Defaults to
checking for a single required argument.

\code{test_fn_num_out()} checks whether the function returns a numeric output
consistent with evaluating the probability density or probability mass
function of a distribution over a sequence of values.
Expects that the function returns a numeric vector of finite values
\eqn{\geq} 0.0, that no values are missing, and that the output vector
is the same length as the input vector.
}
\keyword{internal}
