% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\name{write_bib}
\alias{write_bib}
\alias{write_citation}
\title{Previous API: Write files}
\usage{
write_bib(x, file = tempfile(), append = FALSE, verbose = TRUE, ascii = FALSE)

write_citation(
  x,
  file = "./inst/CITATION",
  append = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x}{A \code{\link{bibentry}} or a \code{\link{cff}} object.}

\item{file}{Name of the file to be created. If \code{NULL} it would display the
lines to be written.}

\item{append}{Whether to append the entries to an existing file or not.}

\item{verbose}{Display informative messages}

\item{ascii}{Whether to write the entries using ASCII characters only or not.}
}
\value{
Write a file.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use \code{\link[=cff_write_bib]{cff_write_bib()}} or
\code{\link[=cff_write_citation]{cff_write_citation()}} instead.
}
\examples{

bib <- bibentry("Misc",
  title = "My title",
  author = "Fran Pérez"
)

my_temp_bib <- tempfile(fileext = ".bib")

cff_write_bib(bib, file = my_temp_bib)

cat(readLines(my_temp_bib), sep = "\n")

cff_write_bib(bib, file = my_temp_bib, ascii = TRUE, append = TRUE)

cat(readLines(my_temp_bib), sep = "\n")
}
\seealso{
\itemize{
\item \code{\link[=cff_write_bib]{cff_write_bib()}} for writing \verb{*.bib} files.
\item \code{\link[=cff_write_citation]{cff_write_citation()}} for writing \strong{R} \code{CITATION} files.
}

Other deprecated functions:
\code{\link{cff_extract_to_bibtex}()},
\code{\link{cff_from_bibtex}()},
\code{\link{cff_parse_citation}()},
\code{\link{cff_parse_person}()}
}
\concept{deprecated}
\keyword{internal}
