% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cff_parse_citation.R
\name{cff_parse_citation}
\alias{cff_parse_citation}
\title{Parse a \code{bibentry} to \code{cff}}
\usage{
cff_parse_citation(bib)
}
\arguments{
\item{bib}{A \code{bibentry} object, either created with \code{\link[=bibentry]{bibentry()}}
(preferred) or \code{\link[=citEntry]{citEntry()}}.}
}
\value{
A \code{\link{cff}} object ready to be used on \code{\link[=cff_create]{cff_create()}}.
}
\description{
Parse a \code{bibentry} object to a valid format for a \code{CITATION.cff} file.
}
\details{
This is a helper function designed to help on adding or
replacing the auto-generated authors of the package. See \strong{Examples}.

This function tries to adapt a \code{bibentry} object (generated with \code{\link[=bibentry]{bibentry()}}
or \code{\link[=citEntry]{citEntry()}}) to the CFF standard.
\subsection{Entry types considered}{
\itemize{
\item \strong{Article}, \strong{Book}, \strong{Booklet}, \strong{InBook}, \strong{InCollection},
\strong{InProceedings}, \strong{Manual}, \strong{MastersThesis}, \strong{Misc}, \strong{PhDThesis},
\strong{Proceedings}, \strong{TechReport}, \strong{Unpublished}. See \code{\link[=bibentry]{bibentry()}}
for more information.
}

Note that \strong{Conference} is not implemented in
\code{\link[=bibentry]{bibentry()}}, however is equivalent to \strong{InProceedings} (Patashnik (1988)).
}

\subsection{Fields considered}{
\itemize{
\item \strong{address}, \strong{author}, \strong{booktitle}, \strong{chapter}, \strong{edition},
\strong{editor}, \strong{howpublished}, \strong{institution},  \strong{journal}, \strong{key},
\strong{month}, \strong{note}, \strong{number}, \strong{organization}, \strong{pages},
\strong{publisher}, \strong{school}, \strong{series}, \strong{title}, \strong{type}, \strong{year}.
}

\strong{annote} and \strong{crossref} fields are ignored.
}
}
\examples{
\donttest{
bib <- citation("base")
bib


# To cff
bib_to_cff <- cff_parse_citation(bib)
bib_to_cff

# Create the object
new_cff <- cff()

full <- cff_create(new_cff, keys = list("preferred-citation" = bib_to_cff))

full
# Validate
cff_validate(full)

# Several citations

cff_parse_citation(citation("rmarkdown"))
}
}
\references{
\itemize{
\item Patashnik, Oren. "BIBTEXTING" February 1988.
\url{https://osl.ugr.es/CTAN/biblio/bibtex/base/btxdoc.pdf}.
\item Haines, R., & The Ruby Citation File Format Developers. (2021).
\emph{Ruby CFF Library (Version 0.9.0)} (Computer software).
\doi{10.5281/zenodo.1184077}.
}
}
\seealso{
\code{\link[=cff_create]{cff_create()}}, \code{vignette("bibtex_cff", "cffr")}, \code{\link[=bibentry]{bibentry()}}

Other parsers: 
\code{\link{cff_parse_person}()}
}
\concept{parsers}
