% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataPlot.R
\name{summary_cfd}
\alias{summary_cfd}
\title{Summary}
\usage{
summary_cfd(data, max.print = 10)
}
\arguments{
\item{data}{data.frame containing \code{id}, id of the trajectory, \code{time}, time at which a change occurs and \code{state}, associated state.}

\item{max.print}{maximal number of states to display}
}
\value{
a list containing:
\itemize{
  \item \code{nRow} number of rows
  \item \code{nInd} number of individuals
  \item \code{timeRange} minimal and maximal time value
  \item \code{uniqueStart} TRUE, if all individuals have the same time start value
  \item \code{uniqueEnd} TRUE, if all individuals have the same time start value
  \item \code{states} vector containing the different states
  \item \code{visit} number of individuals visiting each state
}
}
\description{
Get a summary of the data.frame containin categorical functional data
}
\examples{
data(biofam2)
summary_cfd(biofam2)

}
\author{
Quentin Grimonprez
}
