% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat.R
\name{compute_duration}
\alias{compute_duration}
\title{Compute duration of individuals}
\usage{
compute_duration(data)
}
\arguments{
\item{data}{data.frame containing \code{id}, id of the trajectory, \code{time}, time at which a change occurs and \code{state}, associated state.}
}
\value{
a vector containing the duration of each trajectories
}
\description{
For each individual, compute the duration
}
\examples{
# Simulate the Jukes-Cantor model of nucleotide replacement
K <- 4
PJK <- matrix(1 / 3, nrow = K, ncol = K) - diag(rep(1 / 3, K))
lambda_PJK <- c(1, 1, 1, 1)
d_JK <- generate_Markov(n = 10, K = K, P = PJK, lambda = lambda_PJK, Tmax = 10)


# compute duration of each individual
duration <- compute_duration(d_JK)

hist(duration)
}
\seealso{
\link{hist.duration}
}
\author{
Cristian Preda, Quentin Grimonprez
}
