% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reconstructData.R
\name{reconstructIndicators}
\alias{reconstructIndicators}
\title{Reconstruct the indicators using encoding}
\usage{
reconstructIndicators(
  x,
  nComp = NULL,
  timeValues = NULL,
  propMinEigenvalues = 1e-04
)
}
\arguments{
\item{x}{output of \code{\link{compute_optimal_encoding}} function}

\item{nComp}{number of components to use for the reconstruction. By default, all are used.}

\item{timeValues}{vector containing time values at which compute the indicators. If NULL, the time values from the data}

\item{propMinEigenvalues}{Only if nComp = NULL. Minimal proportion used to estimate the number of non-null eigenvalues}
}
\value{
a data.frame with columns: time, id, state1, ..., stateK, state.
state1 contains the estimated indicator values for the first state.
state contains the state with the maximum values of all indicators
}
\description{
The reconstruction formula is:
\deqn{1^{x}(t) = p^x(t) ( 1 + \sum_{i\geq 1} z_i*a_i^x(t)})

with \eqn{z_i}, the i-th principal component,
encoding \eqn{a_i^x = \sum_j \alpha_{(x, j)} * \phi_j(t)}
and \eqn{p^x(t) =  1 / (\sum_{i \geq 1} a_i^x(t)^2)}
}
\examples{
set.seed(42)
# Simulate the Jukes-Cantor model of nucleotide replacement
K <- 3
Tmax <- 1
d_JK <- generate_Markov(n = 100, K = K, Tmax = Tmax)
d_JK2 <- cut_data(d_JK, Tmax)

# create basis object
m <- 20
b <- create.bspline.basis(c(0, Tmax), nbasis = m, norder = 4)
\donttest{
# compute encoding
encoding <- compute_optimal_encoding(d_JK2, b, computeCI = FALSE, nCores = 1)

indicators <- reconstructIndicators(encoding)

# we plot the first path and its reconstructed indicators
iInd <- 3
plotData(d_JK2[d_JK2$id == iInd, ])

plotIndicatorsReconstruction(indicators, id = iInd)

# the column state contains the state associated with the greatest indicator.
# So, the output can be used with plotData function
plotData(remove_duplicated_states(indicators[indicators$id == iInd, ]))
}
}
\seealso{
\code{\link{plotIndicatorsReconstruction}}
}
\author{
Quentin Grimonprez
}
