% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pretreatment.R
\name{matrixToCfd}
\alias{matrixToCfd}
\title{Convert a matrix to a cfda data.frame}
\usage{
matrixToCfd(X, times = NULL, labels = NULL, byrow = FALSE)
}
\arguments{
\item{X}{matrix containing the states}

\item{times}{time values. If \code{NULL}, it uses a sequence of integers starting with 1}

\item{labels}{id labels. If \code{NULL}, it uses the matrix colnames}

\item{byrow}{if \code{FALSE}, one column = one trajectory}
}
\value{
a data.frame in the cfda format
}
\description{
Convert a matrix to a cfda data.frame
}
\examples{
x <- matrix(c("a", "b", "c", "c",
              "c", "a", "a", "a",
              "b", "c", "a", "b"), ncol = 4, byrow = TRUE,
              dimnames = list(NULL, paste0("ind", 1:4)))
matrixToCfd(x)
}
\seealso{
Other format: 
\code{\link{convertToCfd}()},
\code{\link{cut_data}()},
\code{\link{remove_duplicated_states}()}
}
\concept{format}
