% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbd_venues.R
\name{cfbd_venues}
\alias{cfbd_venues}
\title{\strong{CFBD Venues Endpoint Overview}}
\usage{
cfbd_venues()
}
\value{
A data frame with 337 rows and 13 variables:
\describe{
\item{\code{venue_id}:integer.}{Referencing venue ID.}
\item{\code{name}:character.}{Venue name.}
\item{\code{capacity}:integer.}{Stadium capacity.}
\item{\code{grass}:logical.}{TRUE/FALSE response on whether the field is grass or not (oh, and there are so many others).}
\item{\code{city}:character.}{Venue city.}
\item{\code{state}:character.}{Venue state.}
\item{\code{zip}:character.}{Venue zip.}
\item{\code{country_code}:character.}{Venue country code.}
\item{\code{location}:list.}{Venue location.}
\item{\code{elevation}:character.}{Venue elevation.}
\item{\code{year_constructed}:integer.}{Year in which the venue was constructed.}
\item{\code{dome}:logical.}{TRUE/FALSE response to whether the venue has a dome or not.}
\item{\code{timezone}:character.}{Time zone in which the venue resides (i.e. Eastern Time -> "America/New York").}
}
}
\description{
Pulls all college football venues and data on capacity, grass, city/state, location,
elevation, dome, timezone and construction year.
}
\details{
CFB Venue Information

\if{html}{\out{<div class="sourceCode r">}}\preformatted{ cfbd_venues()
}\if{html}{\out{</div>}}
}
\examples{
\donttest{
  try(cfbd_venues())
}
}
\keyword{Venues}
