% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbd_games.R
\name{cfbd_game_records}
\alias{cfbd_game_records}
\title{\strong{Get team records by year}}
\usage{
cfbd_game_records(year, team = NULL, conference = NULL)
}
\arguments{
\item{year}{(\emph{Integer} optional): Year, 4 digit format (\emph{YYYY})}

\item{team}{(\emph{String} optional): Team - Select a valid team, D1 football}

\item{conference}{(\emph{String} optional): DI Conference abbreviation - Select a valid FBS conference
Conference abbreviations P5: ACC, B12, B1G, SEC, PAC
Conference abbreviations G5 and FBS Independents: CUSA, MAC, MWC, Ind, SBC, AAC}
}
\value{
\code{\link[=cfbd_game_records]{cfbd_game_records()}} - A data frame with 21 variables:
\describe{
\item{\code{year}: integer.}{Season of the games.}
\item{\code{team}: character.}{Team name.}
\item{\code{conference}: character.}{Conference of the team.}
\item{\code{division}: character.}{Division in the conference of the team.}
\item{\code{expected_wins}: numeric}{Expected number of wins based on post-game win probability.}
\item{\code{total_games}: integer.}{Total number of games played.}
\item{\code{total_wins}: integer.}{Total wins.}
\item{\code{total_losses}: integer.}{Total losses.}
\item{\code{total_ties}: integer.}{Total ties.}
\item{\code{conference_games}: integer.}{Number of conference games.}
\item{\code{conference_wins}: integer.}{Total conference wins.}
\item{\code{conference_losses}: integer.}{Total conference losses.}
\item{\code{conference_ties}: integer.}{Total conference ties.}
\item{\code{home_games}: integer.}{Total home games.}
\item{\code{home_wins}: integer.}{Total home wins.}
\item{\code{home_losses}: integer.}{Total home losses.}
\item{\code{home_ties}: integer.}{Total home ties.}
\item{\code{away_games}: integer.}{Total away games.}
\item{\code{away_wins}: integer.}{Total away wins.}
\item{\code{away_losses}: integer.}{Total away losses.}
\item{\code{away_ties}: integer.}{Total away ties.}
}
}
\description{
\strong{Get team records by year}
}
\examples{
\donttest{
  try(cfbd_game_records(2018, team = "Notre Dame"))

  try(cfbd_game_records(2013, team = "Florida State"))
}
}
\keyword{Info}
\keyword{Team}
