% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbd_games.R
\name{cfbd_game_media}
\alias{cfbd_game_media}
\title{\strong{Get game media information (TV, radio, etc).}}
\usage{
cfbd_game_media(
  year,
  week = NULL,
  season_type = "both",
  team = NULL,
  conference = NULL,
  media_type = NULL
)
}
\arguments{
\item{year}{(\emph{Integer} required): Year, 4 digit format (\emph{YYYY})}

\item{week}{(\emph{Integer} optional): Week, values from 1-15, 1-14 for seasons pre-playoff (i.e. 2013 or earlier)}

\item{season_type}{(\emph{String} default both): Select Season Type, regular, postseason, or both}

\item{team}{(\emph{String} optional): D-I Team}

\item{conference}{(\emph{String} optional): Conference abbreviation - Select a valid FBS conference
Conference abbreviations P5: ACC, B12, B1G, SEC, PAC
Conference abbreviations G5 and FBS Independents: CUSA, MAC, MWC, Ind, SBC, AAC}

\item{media_type}{(\emph{String} optional): Media type filter: tv, radio, web, ppv, or mobile}
}
\value{
\code{\link[=cfbd_game_media]{cfbd_game_media()}} - A data frame with 13 variables:
\describe{
\item{\code{game_id}: integer.}{Referencing game id.}
\item{\code{season}: integer.}{Season of the game.}
\item{\code{week}: integer.}{Game week.}
\item{\code{season_type}: character.}{Season type of the game.}
\item{\code{start_time}: character.}{Game start time.}
\item{\code{is_start_time_tbd}: logical.}{TRUE/FALSE flag for if the start time is still to be determined.}
\item{\code{home_team}: character.}{Home team of the game.}
\item{\code{home_conference}: character.}{Conference of the home team.}
\item{\code{away_team}: character.}{Away team of the game.}
\item{\code{away_conference}: character.}{Conference of the away team.}
\item{\code{tv}: list.}{TV broadcast networks.}
\item{\code{radio}: logical.}{Radio broadcast networks.}
\item{\code{web}: list.}{Web viewing platforms carrying the game.}
}
}
\description{
\strong{Get game media information (TV, radio, etc).}
}
\examples{
\donttest{
  try(cfbd_game_media(2019, week = 4, conference = "ACC"))
}
}
\keyword{Game}
\keyword{Info}
