% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/cernn.r
\name{shrink_eigen}
\alias{shrink_eigen}
\title{Nonlinear shrinkage of sample eigenvalues}
\usage{
shrink_eigen(d, lambda, alpha, n)
}
\arguments{
\item{d}{Vector of sample eigenvalues to shrink. These must be nonnegative.}

\item{lambda}{Regularization parameter controling amount of shrinkage towards the target.}

\item{alpha}{Parameter that controls mixture between the trace and inverse trace penalties.}

\item{n}{The number of observations.}
}
\value{
Vector of shrunken eigenvalues.
}
\description{
\code{shrink_eigen} shrinks the sample eigenvalues.
}
\examples{
set.seed(12345)
nLambda <- 100
lambda <- 10**seq(-2,2,length.out=nLambda)
alpha <- 0.5
n <- 10
p <- 5
d <- sort(2*runif(p))
e <- shrink_eigen(d,lambda,alpha,n)

## Plot regularization paths of eigenvalues
matplot(x=log10(lambda),y=t(e),type='l',ylab='shrunken eigenvalue')
}

