% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single.R
\name{cxy_geography}
\alias{cxy_geography}
\title{Geocode Single Coordinate Pair}
\usage{
cxy_geography(
  lon,
  lat,
  benchmark = "Public_AR_Current",
  vintage = "Current_Current"
)
}
\arguments{
\item{lon}{Numeric or String Containing Longitude (x) of Point}

\item{lat}{Numeric or String Containing Latitude (y) of Point}

\item{benchmark}{Optional ID or Name of Census Benchmark. See Details.}

\item{vintage}{Optional ID or Name of Census Vintage. See Details.}
}
\value{
A data.frame containing matched address or NULL if not matches
}
\description{
Provides access to the GeoLookup API of the US Census Bureau. Returns census
    geographies for a single geographic point.
}
\details{
This function can be used to locate geographic information given a geographic point.
    It does not provide an address like a reverse-geocoder

To obtain current valid benchmarks, use the \code{cxy_benchmarks()} function

To use this function, you must specify a valid vintage for your benchmark. You may use
    the \code{cxy_vintages()} function to obtain valid Vintages for a given benchmark.
    See \code{vignette('censusxy')} for a full walkthrough.
}
\examples{
cxy_geography(lon = -90.23324, lat = 38.63593)

}
