% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate_moe.R
\name{aggregate_moe}
\alias{aggregate_moe}
\title{Aggregated margin of error across multiple geographies}
\usage{
aggregate_moe(x)
}
\arguments{
\item{x}{A numeric vector containing margins of error for estimates
in multiple geographies.}
}
\value{
The aggregated margin of error for the geographies.
}
\description{
Aggregated margin of error across multiple geographies
}
\details{
Applies a root sum of squared errors. See page A-14 of this
  guide: https://www.census.gov/library/publications/2009/acs/researchers.html
}
\examples{
x <- c(3, 5, 12, 4)
aggregate_moe(x)
data_frame(x = x, group = c(1, 1, 2, 2)) \%>\%
  group_by(group) \%>\%
  summarise(moe = aggregate_moe(x))

}
\author{
Josie Kressner
}
