% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bag_tree-rpart.R
\name{survival_time_survbagg}
\alias{survival_time_survbagg}
\title{A wrapper for survival times with \code{survbagg} models}
\usage{
survival_time_survbagg(object, new_data)
}
\arguments{
\item{object}{A parsnip \code{model_fit} object resulting from \link[parsnip:details_bag_tree_rpart]{bag_tree() with engine = "rpart"}.}

\item{new_data}{Data for prediction}
}
\value{
A vector.
}
\description{
A wrapper for survival times with \code{survbagg} models
}
\examples{
\dontshow{if (rlang::is_installed("ipred")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bagged_tree <- bag_tree() \%>\%
  set_engine("rpart") \%>\%
  set_mode("censored regression") \%>\%
  fit(Surv(time, status) ~ age + ph.ecog, data = lung)
survival_time_survbagg(bagged_tree, lung[1:3, ])
\dontshow{\}) # examplesIf}
}
\keyword{internal}
