% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bag_tree-rpart.R
\name{survival_prob_survbagg}
\alias{survival_prob_survbagg}
\title{A wrapper for survival probabilities with \code{survbagg} models}
\usage{
survival_prob_survbagg(object, new_data, eval_time, time = deprecated())
}
\arguments{
\item{object}{A parsnip \code{model_fit} object resulting from \link[parsnip:details_bag_tree_rpart]{bag_tree() with engine = "rpart"}.}

\item{new_data}{Data for prediction.}

\item{eval_time}{A vector of prediction times.}

\item{time}{Deprecated in favor of \code{eval_time}. A vector of prediction times.}
}
\value{
A vctrs list of tibbles.
}
\description{
A wrapper for survival probabilities with \code{survbagg} models
}
\examples{
\dontshow{if (rlang::is_installed("ipred")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bagged_tree <- bag_tree() \%>\%
  set_engine("rpart") \%>\%
  set_mode("censored regression") \%>\%
  fit(Surv(time, status) ~ age + ph.ecog, data = lung)
survival_prob_survbagg(bagged_tree, lung[1:3, ], eval_time = 100)
\dontshow{\}) # examplesIf}
}
\keyword{internal}
