% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rand_forest-aorsf.R
\name{aorsf_internal}
\alias{aorsf_internal}
\alias{survival_prob_orsf}
\title{Internal helper function for aorsf objects}
\usage{
survival_prob_orsf(object, new_data, eval_time, time = deprecated())
}
\arguments{
\item{object}{A parsnip \code{model_fit} object resulting from
\link[parsnip:details_rand_forest_aorsf]{rand_forest() with engine = "aorsf"}.}

\item{new_data}{A data frame to be predicted.}

\item{eval_time}{A vector of times to predict the survival probability.}

\item{time}{Deprecated in favor of \code{eval_time}. A vector of times to predict the survival probability.}
}
\value{
A tibble with a list column of nested tibbles.
}
\description{
Internal helper function for aorsf objects
}
\examples{
\dontshow{if (rlang::is_installed("aorsf")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
mod <- rand_forest() \%>\%
  set_engine("aorsf") \%>\%
  set_mode("censored regression") \%>\%
  fit(Surv(time, status) ~ age + ph.ecog, data = na.omit(lung))
preds <- survival_prob_orsf(mod, lung[1:3, ], eval_time = c(250, 100))
\dontshow{\}) # examplesIf}
}
\keyword{internal}
