% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect.R
\name{censo_conectar}
\alias{censo_conectar}
\title{Conexion a la Base de Datos del Censo}
\usage{
censo_conectar(dir = censo_path())
}
\arguments{
\item{dir}{La ubicacion de la base de datos en el disco. Por defecto es
\code{censo2017} en la carpeta de datos del usuario de R o la variable de entorno
\code{CENSO2017_DIR} si el usuario la especifica.}
}
\description{
Devuelve una conexion a la base de datos local. Esto corresponde a una
conexion a una base DuckDB compatible con DBI. A diferencia de
\code{\link[=censo_tabla]{censo_tabla()}}, esta funcion es mas flexible y se puede usar con
dbplyr para leer unicamente lo que se necesita o directamente con DBI para
usar comandos SQL.
}
\examples{
\dontrun{
 DBI::dbListTables(censo_conectar())

 DBI::dbGetQuery(
  censo_conectar(),
  'SELECT * FROM comunas WHERE provincia_ref_id = 1'
 )
}
}
