% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_r_environ.R
\name{add_r_environ}
\alias{add_r_environ}
\title{Add Entry to Renviron}
\usage{
add_r_environ(
  value,
  name = "CENSUS_API_KEY",
  overwrite = FALSE,
  install = FALSE
)
}
\arguments{
\item{value}{Character. Value to add.}

\item{name}{Defaults to CENSUS_API_KEY. Character. Name to give \code{value}.}

\item{overwrite}{Defaults to FALSE. Boolean. Should existing item with name \code{name} in Renviron be overwritten?}

\item{install}{Defaults to FALSE. Boolean. Should this be added '~/.Renviron' file?}
}
\value{
value, invisibly
}
\description{
Adds a value to the Renvironment of the form \code{name=value}. Designed for flexibly
adding API keys for future sessions. Defaults are set up for entering a Census API
key to work with tidycensus.
}
\examples{
\dontrun{
add_r_environ('1234', 'SECRET_API_KEY')
}

}
