% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reader.R
\name{read_data}
\alias{read_data}
\title{Read Seahorse Wave Excel File}
\usage{
read_data(rep_list, norm = NULL, sheet = 2, delimiter = " ")
}
\arguments{
\item{rep_list}{A list of Seahorse Wave excel export files. One file per
replicate. If your data is in a directory called "seahorse_data", use
\code{list.files("seahorse_data", pattern = "*.xlsx", full.names = TRUE)} to make
a list of the excel files.}

\item{norm}{A csv file with the experimental groups and their normalization
values. Leave unset if normalization is not required. See \code{\link[=normalize]{normalize()}}.}

\item{sheet}{The number of the excel sheet containing the long-form Seahorse
data. Default is 2 because the long-form output from Seahorse Wave is on
sheet 2}

\item{delimiter}{The delimiter between the group name and the assay type in
the Group column of the wave output. e.g. "Group1 MITO" would use a space
character as delimiter.}
}
\value{
a seahorse_rates table
}
\description{
Reads input seahore data from an excel Seahorse Wave File. It  assumes your
data is background normalized.
}
\examples{
rep_list <- system.file("extdata", package = "ceas") |>
  list.files(pattern = "*.xlsx", full.names = TRUE)
seahorse_rates <- read_data(rep_list, sheet = 2)
head(seahorse_rates, n = 10)

# normalization
norm_csv <- system.file("extdata", package = "ceas") |>
  list.files(pattern = "norm.csv", full.names = TRUE)
seahorse_rates.norm <- read_data(rep_list, norm = norm_csv, sheet = 2)
head(seahorse_rates.norm, n = 10)
}
