% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdgd1_ml.R
\name{cdgd1_ml}
\alias{cdgd1_ml}
\title{Perform conditional decomposition via machine learning}
\usage{
cdgd1_ml(Y, D, G, X, Q, data, algorithm, alpha = 0.05, trim1 = 0, trim2 = 0)
}
\arguments{
\item{Y}{Outcome. The name of a numeric variable.}

\item{D}{Treatment status. The name of a binary numeric variable taking values of 0 and 1.}

\item{G}{Advantaged group membership. The name of a binary numeric variable taking values of 0 and 1.}

\item{X}{Confounders. A vector of names of numeric variables.}

\item{Q}{Conditional set. A vector of names of numeric variables.}

\item{data}{A data frame.}

\item{algorithm}{The ML algorithm for modelling. "nnet" for neural network, "ranger" for random forests, "gbm" for generalized boosted models.}

\item{alpha}{1-alpha confidence interval.}

\item{trim1}{Threshold for trimming the propensity score. When trim1=a, individuals with propensity scores lower than a or higher than 1-a will be dropped.}

\item{trim2}{Threshold for trimming the G given Q predictions. When trim2=a, individuals with G given Q predictions lower than a or higher than 1-a will be dropped.}
}
\value{
A dataframe of estimates.
}
\description{
Perform conditional decomposition via machine learning
}
\examples{
# This example will take a minute to run.
\donttest{
data(exp_data)

set.seed(1)

results <- cdgd1_ml(
Y="outcome",
D="treatment",
G="group_a",
X="confounder",
Q="Q",
data=exp_data,
algorithm="gbm")

results}
}
