% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen.data.R
\name{gen.data}
\alias{gen.data}
\title{Data generation}
\usage{
gen.data(
  N = NULL,
  R = 1,
  item.bank = NULL,
  att.profiles = NULL,
  att.dist = "uniform",
  mvnorm.parm = list(mean = NULL, sigma = NULL, cutoffs = NULL),
  higher.order.parm = list(theta = NULL, lambda = NULL),
  categorical.parm = list(att.prior = NULL),
  seed = NULL
)
}
\arguments{
\item{N}{Scalar numeric. Sample size for the datasets}

\item{R}{Scalar numeric. Number of datasets replications. Default is 1}

\item{item.bank}{An object of class \code{gen.itembank}}

\item{att.profiles}{Numeric matrix indicating the true attribute profile for each examinee (\emph{N} examinees x \emph{K} attributes). If \code{NULL} (by default), \code{att.dist} must be specified}

\item{att.dist}{Numeric vector of length 2^\emph{K}, where \emph{K} is the number of attributes. Distribution for attribute simulation. It can be \code{"uniform"} (by default), \code{"higher.order"}, \code{"mvnorm"}, or \code{"categorical"}. See \code{simGDINA} function of package \code{GDINA} for more information. Only used when \code{att.profiles = NULL}}

\item{mvnorm.parm}{A list of arguments for multivariate normal attribute distribution (\code{att.dist = "mvnorm"}). See \code{simGDINA} function of package \code{GDINA} for more information}

\item{higher.order.parm}{A list of arguments for higher-order attribute distribution (\code{att.dist = "higher.order"}). See \code{simGDINA} function of package \code{GDINA} for more information}

\item{categorical.parm}{A list of arguments for categorical attribute distribution (\code{att.dist = "categorical"}). See \code{simGDINA} function of package \code{GDINA} for more information}

\item{seed}{Scalar numeric. A scalar to use with \code{set.seed}}
}
\value{
\code{gen.data} returns an object of class \code{gen.data}.
\describe{
\item{simdat}{An array containing the simulated responses (dimensions N examinees x J items x R replicates). If \code{R = 1}, a matrix is provided}
\item{simalpha}{An array containing the simulated attribute profiles (dimensions N examinees x K attributes x R replicates). If \code{R = 1}, a matrix is provided}
\item{specifications}{A list that contains all the specifications}
}
}
\description{
This function can be used to generate datasets based on an object of class \code{gen.itembank}.
The user can manipulate the examinees' attribute distribution or provide a matrix of attribute profiles.
Data are simulated using the \code{GDINA::simGDINA} function (Ma & de la Torre, 2020).
}
\examples{

####################################
# Example 1.                       #
# Generate dataset (GDINA item     #
# parameters and uniform attribute #
# distribution)                    #
####################################

Q <- sim180GDINA$simQ
bank <- gen.itembank(Q = Q, mean.IQ = .70, range.IQ = .20, model = "GDINA")

simdata <- gen.data(N = 1000, item.bank = bank)


}
\references{
Ma, W. & de la Torre, J. (2020). GDINA: The generalized DINA model framework. R package version 2.7.9. Retrived from https://CRAN.R-project.org/package=GDINA
}
