% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DefOps.R, R/LocalOps.R, R/relops.R
\name{build_pivot_control}
\alias{build_pivot_control}
\alias{build_pivot_control.default}
\alias{build_pivot_control.relop}
\title{Build a blocks_to_rowrecs()/rowrecs_to_blocks() control table that specifies a pivot from a \code{data.frame}.}
\usage{
build_pivot_control(
  table,
  columnToTakeKeysFrom,
  columnToTakeValuesFrom,
  ...,
  prefix = columnToTakeKeysFrom,
  sep = NULL,
  tmp_name_source = wrapr::mk_tmp_name_source("bpc"),
  temporary = FALSE
)

\method{build_pivot_control}{default}(
  table,
  columnToTakeKeysFrom,
  columnToTakeValuesFrom,
  ...,
  prefix = columnToTakeKeysFrom,
  sep = NULL,
  tmp_name_source = wrapr::mk_tmp_name_source("bpcd"),
  temporary = TRUE
)

\method{build_pivot_control}{relop}(
  table,
  columnToTakeKeysFrom,
  columnToTakeValuesFrom,
  ...,
  prefix = columnToTakeKeysFrom,
  sep = NULL,
  tmp_name_source = wrapr::mk_tmp_name_source("bpc"),
  temporary = FALSE
)
}
\arguments{
\item{table}{data.frame to scan for new column names (in-memory data.frame).}

\item{columnToTakeKeysFrom}{character name of column build new column names from.}

\item{columnToTakeValuesFrom}{character name of column to get values from.}

\item{...}{not used, force later args to be by name}

\item{prefix}{column name prefix (only used when sep is not NULL)}

\item{sep}{separator to build complex column names.}

\item{tmp_name_source}{a tempNameGenerator from cdata::mk_tmp_name_source()}

\item{temporary}{logical, if TRUE use temporary tables}
}
\value{
control table
}
\description{
Some discussion and examples can be found here: \url{https://winvector.github.io/FluidData/FluidData.html}.
}
\examples{

  d <- data.frame(measType = c("wt", "ht"),
                  measValue = c(150, 6),
                  stringsAsFactors = FALSE)
  build_pivot_control(d,
                      'measType', 'measValue',
                      sep = '_')


d <- data.frame(measType = c("wt", "ht"),
                measValue = c(150, 6),
                stringsAsFactors = FALSE)

ops <- rquery::local_td(d) \%.>\%
  build_pivot_control(.,
                      'measType', 'measValue',
                      sep = '_')
cat(format(ops))

if(requireNamespace("rqdatatable", quietly = TRUE)) {
  library("rqdatatable")
  d \%.>\%
    ops \%.>\%
    print(.)
}

if(requireNamespace("RSQLite", quietly = TRUE)) {
  db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  DBI::dbWriteTable(db,
                    'd',
                    d,
                    overwrite = TRUE,
                    temporary = TRUE)
  db \%.>\%
    ops \%.>\%
    print(.)
  DBI::dbDisconnect(db)
}

}
\seealso{
\code{\link{blocks_to_rowrecs}}
}
