% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LocalOps.R, R/relops.R
\name{rowrecs_to_blocks}
\alias{rowrecs_to_blocks}
\alias{rowrecs_to_blocks.default}
\alias{rowrecs_to_blocks.relop}
\title{Map a set of columns to rows (takes a \code{data.frame}).}
\usage{
rowrecs_to_blocks(wideTable, controlTable, ..., checkNames = TRUE,
  checkKeys = FALSE, strict = FALSE, columnsToCopy = NULL,
  use_data_table = FALSE)

\method{rowrecs_to_blocks}{default}(wideTable, controlTable, ...,
  checkNames = TRUE, checkKeys = FALSE, strict = FALSE,
  columnsToCopy = NULL, use_data_table = FALSE)

\method{rowrecs_to_blocks}{relop}(wideTable, controlTable, ...,
  checkNames = TRUE, strict = FALSE, columnsToCopy = NULL,
  use_data_table = TRUE,
  tmp_name_source = wrapr::mk_tmp_name_source("rrtbl"),
  temporary = TRUE)
}
\arguments{
\item{wideTable}{data.frame containing data to be mapped (in-memory data.frame).}

\item{controlTable}{table specifying mapping (local data frame).}

\item{...}{force later arguments to be by name.}

\item{checkNames}{logical, if TRUE check names.}

\item{checkKeys}{logical, if TRUE check columnsToCopy form row keys (not a requirement, unless you want to be able to invert the operation).}

\item{strict}{logical, if TRUE check control table name forms.}

\item{columnsToCopy}{character array of column names to copy.}

\item{use_data_table}{logical if TRUE try to use data.table for the un-pivots.}

\item{tmp_name_source}{a tempNameGenerator from cdata::mk_tmp_name_source()}

\item{temporary}{logical, if TRUE make result temporary.}
}
\value{
long table built by mapping wideTable to one row per group
}
\description{
Transform data facts from columns into additional rows controlTable.
}
\details{
This is using the theory of "fluid data"
(\url{https://github.com/WinVector/cdata}), which includes the
principle that each data cell has coordinates independent of the
storage details and storage detail dependent coordinates (usually
row-id, column-id, and group-id) can be re-derived at will (the
other principle is that there may not be "one true preferred data
shape" and many re-shapings of data may be needed to match data to
different algorithms and methods).

The controlTable defines the names of each data element in the two notations:
the notation of the tall table (which is row oriented)
and the notation of the wide table (which is column oriented).
controlTable[ , 1] (the group label) cross colnames(controlTable)
(the column labels) are names of data cells in the long form.
controlTable[ , 2:ncol(controlTable)] (column labels)
are names of data cells in the wide form.
To get behavior similar to tidyr::gather/spread one builds the control table
by running an appropriate query over the data.

Some discussion and examples can be found here:
\url{https://winvector.github.io/FluidData/FluidData.html} and
here \url{https://github.com/WinVector/cdata}.
}
\examples{

  # un-pivot example
  d <- data.frame(AUC = 0.6, R2 = 0.2)
  cT <- build_unpivot_control(nameForNewKeyColumn= 'meas',
                              nameForNewValueColumn= 'val',
                              columnsToTakeFrom= c('AUC', 'R2'))
  rowrecs_to_blocks(d, cT)



d <- data.frame(AUC = 0.6, R2 = 0.2)
cT <- build_unpivot_control(
  nameForNewKeyColumn= 'meas',
  nameForNewValueColumn= 'val',
  columnsToTakeFrom= c('AUC', 'R2'))

ops <- rquery::local_td(d) \%.>\%
  rowrecs_to_blocks(., cT)
cat(format(ops))

if(requireNamespace("rqdatatable", quietly = TRUE)) {
  library("rqdatatable")
  d \%.>\%
    ops \%.>\%
    print(.)
}

if(requireNamespace("RSQLite", quietly = TRUE)) {
  db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  DBI::dbWriteTable(db,
                    'd',
                    d,
                    overwrite = TRUE,
                    temporary = TRUE)
  db \%.>\%
    ops \%.>\%
    print(.)
  DBI::dbDisconnect(db)
}

}
\seealso{
\code{\link{build_unpivot_control}}, \code{\link{blocks_to_rowrecs}}
}
