
## ----load,message=FALSE--------------------------------------------------
library(cda)
library(rgl)
library(ggplot2)
library(reshape2)
library(plyr)
library(knitr)


## ----setup,echo=FALSE----------------------------------------------------
knit_hooks$set(rgl = function(before, options, envir) {
  # if a device was opened before this chunk, close it
  if (before && rgl.cur() > 0) rgl.close()
  hook_rgl(before, options, envir)
})
rgl_annotate = function(){
  axes3d( labels = FALSE, tick = FALSE, edges=c("x", "y", "z") )
axis3d(labels = FALSE, tick = FALSE, 'x',pos=c(NA, 0, 0))
axis3d(labels = FALSE, tick = FALSE, 'y',pos=c(0, NA, 0))
axis3d(labels = FALSE, tick = FALSE, 'z',pos=c(0, 0, NA))
title3d('','','x axis','y axis','z axis')
}
theme_set(theme_minimal())


## ----cluster, rgl=TRUE,echo=-12,tidy=FALSE,fig.width=3,fig.height=3,fig.path="basic-"----

# dielectric function
wvl <- seq(400, 900)
gold <- epsAu(wvl)

# define a cluster of particles
cl <- list(r = rbind(c(0, 0, 0),
                      c(0, 0, -100)),
            angles = rbind(c(0, 0, 0),
                           c(pi/4, 0, 0)),
            sizes = rbind(c(30, 10, 10),
                          c(30, 10, 10)))

# visualise
rgl.ellipsoids(cl$r, cl$sizes, cl$angles, col="gold")
rgl.viewpoint( theta = 0, phi = 20, fov = 70, zoom = 1)
rgl_annotate()



## ----linear,echo=TRUE,tidy=FALSE,fig.path="basic-", fig.height=4---------

linear <- dispersion_spectrum(cl, gold)
ggplot(linear, aes(wavelength, value, linetype=type)) +
  facet_wrap(~polarisation) + geom_path()


## ----oa,echo=TRUE,tidy=FALSE,fig.path="basic-",fig.width=8---------------
circular <- circular_dichroism_spectrum(cl, gold)

ggplot(circular, aes(wavelength, value, color=variable)) + 
  facet_grid(type~., scales="free") + geom_line()



