% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ztest.R
\name{Ztest}
\alias{Ztest}
\title{Wald's test on the Concordance Correlation Coefficient}
\usage{
Ztest(cccfit, r0 = 0, tr = TRUE)
}
\arguments{
\item{cccfit}{An object of class \code{ccc}.}

\item{r0}{Integer. Null hypothesis value.}

\item{tr}{Logical. Should the transformed CCC be used? Only applies if a transformation was applied in the \code{ccc} object. Default value is TRUE.}
}
\value{
A data frame with two columns: \code{Z}, the statistical test value; and the P-value associated.
}
\description{
Estimation of the concordance correlation coefficient for either non-repeated, non-longitudinal, or longitudinal repeated measurements using the variance components from a linear mixed model. The appropriate intraclass correlation coefficient is used as estimator of the concordance correlation coefficient.
}
\details{
A one sided test to the null hypothesis value \deqn{\rho_0}.
\deqn{z=\frac{\hat{\theta}-\rho_0}{SE\left(\hat{\theta}\right)}} where \deqn{\hat{\theta}} stands for the CCC estimate and \deqn{SE\left(\hat{\theta}\right)} its standard error.
The p-value is computed as \deqn{P\left(X>z\right)} where X follows a standard Normal distribution.
}
\examples{

# Testing the CCC is above 0.8
ccc_mc=ccc_vc(bpres,"DIA","ID","METODE")
ccc_mc
Ztest(ccc_mc,r0=0.8)

}
