% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response-functional.R
\name{analyze_graph}
\alias{analyze_graph}
\title{Analyze the causal graph to determine constraints and objective}
\usage{
analyze_graph(graph, constraints, effectt)
}
\arguments{
\item{graph}{An \link[igraph]{aaa-igraph-package} object that represents a directed acyclic graph}

\item{constraints}{A vector of character strings that represent the constraints}

\item{effectt}{A character string that represents the causal effect of interest}
}
\value{
A an object of class "linearcausalproblem", which is a list with the following components. This list can be passed to \link{optimize_effect} which interfaces with Balke's code. Print and plot methods are also available. 
    \describe{
        \item{variables}{Character vector of variable names of potential outcomes, these start with 'q' to match Balke's notation} 
        \item{parameters}{Character vector of parameter names of observed probabilities, these start with 'p' to match Balke's notation}
        \item{constraints}{Character vector of parsed constraints}
        \item{objective}{Character string defining the objective to be optimized in terms of the variables}
        \item{p.vals}{Matrix of all possible values of the observed data vector, corresponding to the list of parameters.}
        \item{q.vals}{Matrix of all possible values of the response function form of the potential outcomes, corresponding to the list of variables.}
        \item{parsed.query}{A nested list containing information on the parsed causal query.}
        \item{objective.nonreduced}{The objective in terms of the original variables, before algebraic variable reduction. The nonreduced variables can be obtained by concatenating the columns of q.vals.}
        \item{response.functions}{List of response functions.}
        \item{graph}{The graph as passed to the function.}
    }
}
\description{
The graph must contain edge attributes named "leftside" and "lrconnect"
that takes values 0 and 1. Only one edge may have a value 1 for lrconnect. 
The shiny app returns a graph in this format.
}
\examples{
### confounded exposure and outcome
b <- igraph::graph_from_literal(X -+ Y, Ur -+ X, Ur -+ Y)
V(b)$leftside <- c(0,0,0)
V(b)$latent <- c(0,0,1)
E(b)$rlconnect <- E(b)$edge.monotone <- c(0, 0, 0)
analyze_graph(b, constraints = NULL, effectt = "p{Y(X = 1) = 1} - p{Y(X = 0) = 1}")
}
