% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OT.R
\name{ot_distance}
\alias{ot_distance}
\alias{ot_distance.causalWeights}
\alias{ot_distance.matrix}
\alias{ot_distance.array}
\alias{ot_distance.torch_tensor}
\title{Optimal Transport Distance}
\usage{
ot_distance(
  x1,
  x2 = NULL,
  a = NULL,
  b = NULL,
  penalty,
  p = 2,
  cost = NULL,
  debias = TRUE,
  online.cost = "auto",
  diameter = NULL,
  niter = 1000,
  tol = 1e-07
)

\method{ot_distance}{causalWeights}(
  x1,
  x2 = NULL,
  a = NULL,
  b = NULL,
  penalty,
  p = 2,
  cost = NULL,
  debias = TRUE,
  online.cost = "auto",
  diameter = NULL,
  niter = 1000,
  tol = 1e-07
)

\method{ot_distance}{matrix}(
  x1,
  x2,
  a = NULL,
  b = NULL,
  penalty,
  p = 2,
  cost = NULL,
  debias = TRUE,
  online.cost = "auto",
  diameter = NULL,
  niter = 1000,
  tol = 1e-07
)

\method{ot_distance}{array}(
  x1,
  x2,
  a = NULL,
  b = NULL,
  penalty,
  p = 2,
  cost = NULL,
  debias = TRUE,
  online.cost = "auto",
  diameter = NULL,
  niter = 1000,
  tol = 1e-07
)

\method{ot_distance}{torch_tensor}(
  x1,
  x2,
  a = NULL,
  b = NULL,
  penalty,
  p = 2,
  cost = NULL,
  debias = TRUE,
  online.cost = "auto",
  diameter = NULL,
  niter = 1000,
  tol = 1e-07
)
}
\arguments{
\item{x1}{Either an object of class \linkS4class{causalWeights} or a matrix of the covariates in the first sample}

\item{x2}{\code{NULL} or a matrix of the covariates in the second sample.}

\item{a}{Empirical measure of the first sample. If NULL, assumes each observation gets equal mass. Ignored for objects of class causalWeights.}

\item{b}{Empirical measure of the second sample. If NULL, assumes each observation gets equal mass. Ignored for objects of class causalWeights.}

\item{penalty}{The penalty of the optimal transport distance to use. If missing or NULL, the function will try to guess a suitable value depending if debias is TRUE or FALSE.}

\item{p}{\eqn{L_p} distance metric power}

\item{cost}{Supply your own cost function. Should take arguments \code{x1}, \code{x2}, and \code{p}.}

\item{debias}{TRUE or FALSE. Should the debiased optimal transport distances be used.}

\item{online.cost}{How to calculate the distance matrix. One of "auto", "tensorized", or "online".}

\item{diameter}{The diameter of the metric space, if known. Default is NULL.}

\item{niter}{The maximum number of iterations for the Sinkhorn updates}

\item{tol}{The tolerance for convergence}
}
\value{
For objects of class matrix, numeric value giving the optimal transport distance. For objects of class causalWeights, results are returned as a list for before ('pre') and after adjustment ('post').
}
\description{
Optimal Transport Distance
}
\section{Methods (by class)}{
\itemize{
\item \code{ot_distance(causalWeights)}: method for causalWeights class

\item \code{ot_distance(matrix)}: method for matrices

\item \code{ot_distance(array)}: method for arrays

\item \code{ot_distance(torch_tensor)}: method for torch_tensors

}}
\examples{
if ( torch::torch_is_installed()) {
x <- matrix(stats::rnorm(10*5), 10, 5)
z <- stats::rbinom(10, 1, 0.5)
weights <- calc_weight(x = x, z = z, method = "Logistic", estimand = "ATT")
ot1 <- ot_distance(x1 = weights, penalty = 100, 
p = 2, debias = TRUE, online.cost = "auto", 
diameter = NULL)
ot2<- ot_distance(x1 = x[z==0, ], x2 = x[z == 1,], 
a= weights@w0/sum(weights@w0), b = weights@w1,
 penalty = 100, p = 2, debias = TRUE, online.cost = "auto", diameter = NULL)

 all.equal(ot1$post, ot2) 
}
}
