% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barycentricProjection.R
\name{barycentric_projection}
\alias{barycentric_projection}
\title{Barycentric Projection outcome estimation}
\usage{
barycentric_projection(
  formula,
  data,
  weights,
  separate.samples.on = "z",
  penalty = NULL,
  cost_function = NULL,
  p = 2,
  debias = FALSE,
  cost.online = "auto",
  diameter = NULL,
  niter = 1000L,
  tol = 1e-07,
  ...
)
}
\arguments{
\item{formula}{A formula object specifying the outcome and covariates.}

\item{data}{A data.frame of the data to use in the model.}

\item{weights}{Either a vector of weights, one for each observations, or an object of class \link[=causalWeights-class]{causalWeights}.}

\item{separate.samples.on}{The variable in the data denoting the treatment indicator. How to separate samples for the optimal transport calculation}

\item{penalty}{The penalty parameter to use in the optimal transport calculation. By default it is \eqn{1/\log(n)}{1/log(n)}.}

\item{cost_function}{A user supplied cost function. If supplied, must take arguments \code{x1}, \code{x2}, and \code{p}.}

\item{p}{The power to raise the cost function. Default is 2.0. For user supplied cost functions, the cost will not be raised by this power unless the user so specifies.}

\item{debias}{Should debiased barycentric projections be used? See details.}

\item{cost.online}{Should an online cost algorithm be used? Default is "auto", which selects an online cost algorithm when the sample size in each group specified by \code{separate.samples.on}, \eqn{n_0}{n0} and \eqn{n_1}{n1}, is such that \eqn{n_0 \cdot n_1 \geq 5000^2}{n_0 * n_1 >= 5000^2.} Must be one of "auto", "online", or "tensorized". The last of these is the offline option.}

\item{diameter}{The diameter of the covariate space, if known.}

\item{niter}{The maximum number of iterations to run the optimal transport problems}

\item{tol}{The tolerance for convergence of the optimal transport problems}

\item{...}{Not used at this time.}
}
\value{
An object of class "bp" which is a list with slots:
\itemize{
\item \code{potentials} The dual potentials from calculating the optimal transport distance
\item \code{penalty} The value of the penalty parameter used in calculating the optimal transport distance
\item \code{cost_function} The cost function used to calculate the distances between units.
\item \code{cost_alg} A character vector denoting if an \eqn{L_1}{L1} distance, a squared euclidean distance, or other distance metric was used.
\item \code{p} The power to which the cost matrix was raised if not using a user supplied cost function.
\item \code{debias} Whether barycentric projections should be debiased.
\item \code{tensorized} TRUE/FALSE denoting wether to use offline cost matrices.
\item \code{data} An object of class \linkS4class{dataHolder} with the data used to calculate the optimal transport distance.
\item \code{y_a} The outcome vector in the first sample.
\item \code{y_b} The outcome vector in the second sample.
\item \code{x_a} The covariate matrix in the first sample.
\item \code{x_b} The covariate matrix in the second sample.
\item \code{a} The empirical measure in the first sample.
\item \code{b} The empirical measure in the second sample.
\item \code{terms} The terms object from the formula.
}
}
\description{
Barycentric Projection outcome estimation
}
\details{
The barycentric projection uses the dual potentials from the optimal transport distance between the two samples to calculate projections from one sample into another. For example, in the sample of controls, we may wish to know their outcome had they been treated. In general, we then seek to minimize
\deqn{\text{argmin}_{\eta} \sum_{ij} cost(\eta_i, y_j) \pi_{ij} }
where \eqn{\pi_{ij}} is the primal solution from the optimal transport problem.

These values can also be de-biased using the solutions from running an optimal transport problem of one sample against itself. Details are listed in Pooladian et al. (2022) \url{https://arxiv.org/abs/2202.08919}.
}
\examples{
if(torch::torch_is_installed()) {
set.seed(23483)
n <- 2^5
pp <- 6
overlap <- "low"
design <- "A"
estimate <- "ATT"
power <- 2
data <- causalOT::Hainmueller$new(n = n, p = pp,
design = design, overlap = overlap)

data$gen_data()

weights <- causalOT::calc_weight(x = data,
  z = NULL, y = NULL,
  estimand = estimate,
  method = "NNM")
  
 df <- data.frame(y = data$get_y(), z = data$get_z(), data$get_x())
  
 fit <- causalOT::barycentric_projection(y ~ ., data = df, 
    weight = weights,
    separate.samples.on = "z",
    niter = 2)
 inherits(fit, "bp")
 }
}
