% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cost_functions.R
\name{cost_fun}
\alias{cost_fun}
\title{Calculate cost matrix for a given estimand}
\usage{
cost_fun(x, z, power = 2, metric = dist.metrics(), estimand = "ATE", ...)
}
\arguments{
\item{x}{An object of class \code{matrix}}

\item{z}{A treatment indicator with values in 0 and 1. Should be of class
\code{integer} or \code{vector}}

\item{power}{The power used to calculate the the cost matrix: \eqn{\{(x-y)^{power}\}^{(1/{power})}}}

\item{metric}{One of the values in \link[=dist.metrics]{dist.metrics}.}

\item{estimand}{The estimand desired for the weighting estimator. See details}

\item{...}{Arguments passed to the RKHS calculating function including
\itemize{
\item \code{kernel}, one of "RBF", "polynomial", "linear"
\item \code{rkhs.args} The arguments used to construct the kernel
}
\code{...} can also be used to handle extra arguments passed by mistake so that
an error is not thrown.}
}
\value{
Output depends on the estimand.
\itemize{
\item For ATT and ATC: a matrix of dimension \deqn{n_0 \times n_1}{n_0 * n_1}.
\item For ATE: a list of two matrices of dimension \eqn{n_0 \times n}{n_0 * n} and \eqn{n_1 \times n}.
See details for more information.
}
}
\description{
Calculate cost matrix for a given estimand
}
\details{
If the estimand is "ATT" or "ATC", \code{cost_fun} will calculate
the cost matrix where the rows are the control
and the columns are the treated. If "ATE" will calculate to cost matrices
with the first having the rows corresponding to the control individual and the
second having rows correspond to the treated individuals. For both matrices,
the columns will correspond to the full sample. The dimensions of the output will
depend on the estimand. For reference, let \eqn{n_1 = \sum_i z_i},
\eqn{n_0 = \sum_i (1-z_i)}, and \eqn{n = n_1 + n_0}.
}
\examples{
n0 <- 100
n1 <- 55
d <- 5
x1 <- matrix(stats::rnorm(n1*d), n1, d)
x0 <- matrix(stats::rnorm(n0*d), n0, d)

x <- rbind(x0,x1)
z <- c(rep(0,n0), rep(1,n1))
power <- 2.0

# ATT
estimand <- "ATT"
metric <- "Lp"
cost_ATT <- cost_fun(x, z, power = power, metric = metric, estimand = estimand)
print(dim(cost_ATT))

# ATE
estimand <- "ATE"
cost_ATT <- cost_fun(x, z, power = power, metric = metric, estimand = estimand)
length(cost_ATT)
}
