% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{prior}
\alias{prior}
\title{Evaluate the Prior Density Distribution at Position \eqn{theta}}
\usage{
prior(catObj, theta)
}
\arguments{
\item{catObj}{An object of class \code{Cat}.}

\item{theta}{A numeric value at which to evaluate the prior}
}
\value{
The function \code{prior} returns a numeric consisting of prior value, \eqn{\pi(\theta)}, given the value \eqn{\theta}.
}
\description{
Calculates the density at \code{theta} of either the normal, Student's t, or uniform distribution.
}
\details{
The \code{priorName} slot of \code{Cat} object needs to be either \code{"UNIFORM"}, \code{"NORMAL"}, or \code{"STUDENT_T"}.

When \code{priorName} slot is \code{"NORMAL"}, the first element of \code{priorParams} slot is the mean, 
the second element is the standard deviation.

When \code{priorName} slot is \code{"STUDENT_T"}, the first 
element of \code{priorParams} slot is the non-centrality parameters and the second is degrees of freedom.  

When \code{priorName} slot is \code{"UNIFORM"}, the elements of the \code{priorParams} slot are the lower and upper bounds,
of the interval, respectively.  Note that the \code{"UNIFORM"} is only applicable for the expected a posteriori (EAP) estimation method.
}
\note{
This function is to allow users to access the internal functions of the package. During item selection, all calculations are done in compiled \code{C++} code.

This function uses Boost \code{C++} source libraries for the uniform and Student's t
distributions and calls \code{dnorm4} written in \code{C} which is identical to that 
of \code{dnorm} in \code{R}.
}
\examples{
## Loading ltm Cat object
data(ltm_cat)

## Prior calculation for different distributions
ltm_cat@priorName <- "NORMAL"
ltm_cat@priorParams <- c(0, 1) ## Parameters are mean and standard deviation
prior(ltm_cat, theta = 1)

ltm_cat@priorName <- "STUDENT_T"
ltm_cat@priorParams <- c(1, 3) ## Parameters are non-centrality param and degrees of freedom
prior(ltm_cat, theta = 1)

ltm_cat@priorName <- "UNIFORM"
ltm_cat@priorParams <- c(-1, 1) ## Parameters are lower bound and upper bound of interval
prior(ltm_cat, theta = 1)


}
\seealso{
\code{\link{Cat-class}}
}
\author{
Haley Acevedo, Ryden Butler, Josh W. Cutler, Matt Malis, Jacob M. Montgomery,
 Tom Wilkinson, Erin Rossiter, Min Hee Seo, Alex Weil
}
