% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define_contrast.R
\name{define_contrast}
\alias{define_contrast}
\title{Define a contrast (matrix) to specify exact hypothesis system}
\usage{
define_contrast(type = c("raw", "dunnett", "tukey"), comparator = NA)
}
\arguments{
\item{type}{character, either "Raw", "dunnett" or "tukey")}

\item{comparator}{either integer (index of comparator) or character (name of comparator)}
}
\value{
\code{cases_contrast} object to be passed to \code{\link{evaluate}}
}
\description{
Define a contrast (matrix) to specify exact hypothesis system
}
\details{
"raw" contrast: compare all candidates against specified benchmark values

"dunnett" (all vs. one) contrast: compare all candidates to a single comparator.

"tukey" (all vs. all) contrast: compare all candidates against each other.
}
\examples{
define_contrast("dunnett", 1)
}
