% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decelmerge.R
\name{decelmerge}
\alias{decelmerge}
\title{The \code{decelmerge} function estimates the relative locations of two vehicles where one passes the other.}
\usage{
decelmerge(tstart, tend, umn, usd, xstart, xfunnel, leff)
}
\arguments{
\item{tstart}{start time, a number}

\item{tend}{end time, a number}

\item{umn}{start speed (mph) for vehicle in lane 1, a number}

\item{usd}{speed volatility for \code{umn}, a number}

\item{xstart}{start location for vehicle in lane 1 (feet), a number}

\item{xfunnel}{upstream location where the lane drop starts (feet), a number}

\item{leff}{effective vehicle length(feet), a number}
}
\value{
\code{decelmerge} uses a deterministic model to show the locations of vehicle accelerating to pass
another vehicle traveling side-by-side at the same speed.
}
\description{
The \code{decelmerge} function estimates the relative locations of two vehicles where one passes the other.
}
\examples{
decelmerge(0, 10, 41, 0, -1000, -500, 14)
}
