% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getGridLayer.R
\name{getGridLayer}
\alias{getGridLayer}
\title{Build a Regular Grid Layer}
\usage{
getGridLayer(x, cellsize, type = "regular", var, spdf, spdfid)
}
\arguments{
\item{x}{an sf object, a simple feature collection or a SpatialPolygonsDataFrame.}

\item{cellsize}{targeted area of the cell, in map units.}

\item{type}{shape of the cell, "regular" for squares, "hexagonal" for hexagons.}

\item{var}{name of the numeric variable(s) in x to adapt to the grid (a vector).}

\item{spdf}{defunct.}

\item{spdfid}{defunct.}
}
\value{
A grid is returned as an sf object.
}
\description{
Build a regular grid based on an sf object or a SpatialPolygonsDataFrame.
}
\examples{
library(sf)
mtq <- st_read(system.file("gpkg/mtq.gpkg", package="cartography"))
# Plot dentsity of population
mtq$POPDENS <- 1e6 * mtq$POP / st_area(mtq) 
bks <- getBreaks(v = mtq$POPDENS, method = "geom", 5)
cols <- carto.pal(pal1 = "taupe.pal", n1 = 5)
opar <- par(mfrow = c(1,2), mar = c(0,0,0,0))
choroLayer(x = mtq, var = "POPDENS", breaks = bks,
           border = "burlywood3", col = cols,
           legend.pos = "topright", legend.values.rnd = 0,
           legend.title.txt = "Population density")

mygrid <- getGridLayer(x = mtq, cellsize = 3e7,
                       type = "hexagonal", var = "POP")
## conversion from square meter to square kilometers
mygrid$POPDENSG <- 1e6 * mygrid$POP / mygrid$gridarea 
choroLayer(x = mygrid, var = "POPDENSG", breaks = bks,
           border = "burlywood3", col = cols,
           legend.pos = "n", legend.values.rnd = 1,
           legend.title.txt = "Population density")
par(opar)
}
