% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layoutLayer.R
\name{layoutLayer}
\alias{layoutLayer}
\title{Layout Layer}
\usage{
layoutLayer(title = "Title of the map, year", sources = "",
  author = "", horiz = TRUE, col = "black", coltitle = "white",
  theme = NULL, bg = NULL, scale = "auto",
  posscale = "bottomright", frame = TRUE, north = FALSE,
  south = FALSE, extent = NULL, tabtitle = FALSE,
  postitle = "left")
}
\arguments{
\item{title}{title of the map.}

\item{sources}{sources of the map (or something else).}

\item{author}{author of the map (or something else).}

\item{horiz}{orientation of sources and author. TRUE for horizontal display 
on the bottom left corner, FALSE for vertical display on the bottom right 
corner.}

\item{col}{color of the title box and frame border.}

\item{coltitle}{color of the title.}

\item{theme}{name of a cartographic palette (see \link{carto.pal.info}). 
col and coltitle are set according to the chosen palette.}

\item{bg}{color of the frame background.}

\item{scale}{size of the scale bar in kilometers. If set to FALSE, no scale 
bar is displayed, if set to "auto" an automatic size is used (1/10 of the map 
width).}

\item{posscale}{position of the scale, can be "bottomright", "bottomleft" or 
a vector of two coordinates (c(x, y))}

\item{frame}{whether displaying a frame (TRUE) or not (FALSE).}

\item{north}{whether displaying a North arrow (TRUE) or not (FALSE).}

\item{south}{whether displaying a South arrow (TRUE) or not (FALSE).}

\item{extent}{sf object or Spatial*DataFrame; sets the extent of the frame to 
the one of a spatial object. (optional)}

\item{tabtitle}{size of the title box either a full banner (FALSE) or a 
"tab" (TRUE).}

\item{postitle}{position of the title, one of "left", "center", "right".}
}
\description{
Plot a layout layer.
}
\details{
If extent is not set, plot.new has to be called first.\cr
The size of the title box in layoutLayer is fixed to 1.2 lines height.
}
\examples{
library(sf)
mtq <- st_read(system.file("gpkg/mtq.gpkg", package="cartography"))
plot(st_geometry(mtq), col = "#D1914D", border = "white", bg = "#A6CAE0")
# Layout plot
layoutLayer()

plot(st_geometry(mtq), col = "#D1914D", border = "white", bg = "#A6CAE0")
# Layout plot
layoutLayer(title = "Martinique",
            author =  paste0("cartography ", packageVersion("cartography")),
            tabtitle = TRUE, scale = 5, north = TRUE, frame = FALSE,
            theme = "sand.pal")
}
\seealso{
\link{labelLayer}
}
