% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getLinkLayer.R
\name{getLinkLayer}
\alias{getLinkLayer}
\title{Create a Links Layer from a Data Frame of Links.}
\usage{
getLinkLayer(x, xid = NULL, df, dfid = NULL, spdf, spdf2 = NULL,
  spdfid = NULL, spdf2id = NULL, dfids = NULL, dfide = NULL)
}
\arguments{
\item{x}{an sf object, a simple feature collection (or a Spatial*DataFrame).}

\item{xid}{name of the identifier variable in x, default to the first column (optional)}

\item{df}{a data frame that contains identifiers of starting and ending points.}

\item{dfid}{names of the identifier variables in df, character vector of length 2, default to 
the two first columns. (optional)}

\item{spdf}{defunct.}

\item{spdf2}{defunct.}

\item{spdfid}{defunct.}

\item{spdf2id}{defunct.}

\item{dfids}{defunct.}

\item{dfide}{defunct.}
}
\value{
An sf LINESTRING is returned, it contains two variables (origins and destinations).
}
\description{
Create a links layer from a data frame of links.
}
\examples{
library(sf)
mtq <- st_read(system.file("gpkg/mtq.gpkg", package="cartography"))
mob <- read.csv(system.file("csv/mob.csv", package="cartography"))
# Select links from Fort-de-France (97209))
mob_97209 <- mob[mob$i == 97209, ]
# Create a link layer
mob.sf <- getLinkLayer(x = mtq, df = mob_97209, dfid = c("i", "j"))
# Plot the links1
plot(st_geometry(mtq), col = "grey")
plot(st_geometry(mob.sf), col = "red4", lwd = 2, add = TRUE)
}
\seealso{
\link{gradLinkLayer}, \link{propLinkLayer}
}
