% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothLayer.R
\name{smoothLayer}
\alias{smoothLayer}
\title{Smooth Layer}
\usage{
smoothLayer(x, spdf, df, spdfid = NULL, dfid = NULL, var, var2 = NULL,
  typefct = "exponential", span, beta, resolution = NULL, mask = NULL,
  nclass = 8, breaks = NULL, col = NULL, border = "grey20", lwd = 1,
  legend.pos = "bottomleft", legend.title.txt = "Potential",
  legend.title.cex = 0.8, legend.values.cex = 0.6, legend.values.rnd = 0,
  legend.frame = FALSE, add = FALSE)
}
\arguments{
\item{x}{an sf object, a simple feature collection.}

\item{spdf}{a SpatialPolygonsDataFrame.}

\item{df}{a data frame that contains the values to compute If df is missing 
spdf@data is used instead.}

\item{spdfid}{name of the identifier field in spdf, default to the first column 
of the spdf data frame. (optional)}

\item{dfid}{name of the identifier field in df, default to the first column 
of df. (optional)}

\item{var}{name of the numeric field in df used to compute potentials.}

\item{var2}{name of the numeric field in df used to compute potentials. 
This field is used for ratio computation (see Details).}

\item{typefct}{character; spatial interaction function. Options are "pareto" 
(means power law) or "exponential".
If "pareto" the interaction is defined as: (1 + alpha * mDistance) ^ (-beta).
If "exponential" the interaction is defined as: 
exp(- alpha * mDistance ^ beta).
The alpha parameter is computed from parameters given by the user 
(\code{beta} and \code{span}).}

\item{span}{numeric; distance where the density of probability of the spatial 
interaction function equals 0.5.}

\item{beta}{numeric; impedance factor for the spatial interaction function.}

\item{resolution}{numeric; resolution of the output SpatialPointsDataFrame
(in map units).}

\item{mask}{sf object or SpatialPolygonsDataFrame; mask used to clip contours of potentials.}

\item{nclass}{numeric; a targeted number of classes (default to 8). Not used if breaks is set.}

\item{breaks}{numeric; a vector of values used to discretize the potentials.}

\item{col}{a vector of colors. Note that if breaks is specified there must be one less 
colors specified than the number of break.}

\item{border}{color of the polygons borders.}

\item{lwd}{borders width.}

\item{legend.pos}{position of the legend, one of "topleft", "top", 
"topright", "right", "bottomright", "bottom", "bottomleft", "left" or a 
vector of two coordinates in map units (c(x, y)). If 
legend.pos is "n" then the legend is not plotted.}

\item{legend.title.txt}{title of the legend.}

\item{legend.title.cex}{size of the legend title.}

\item{legend.values.cex}{size of the values in the legend.}

\item{legend.values.rnd}{number of decimal places of the values in 
the legend.}

\item{legend.frame}{whether to add a frame to the legend (TRUE) or 
not (FALSE).}

\item{add}{whether to add the layer to an existing plot (TRUE) or 
not (FALSE).}
}
\value{
An \code{\link{invisible}} sf object (MULTIPOLYGONs) is returned (see \code{\link[SpatialPosition:quickStewart]{quickStewart}}).
}
\description{
Plot a layer of smoothed data. It can also compute a ratio of potentials.\cr \cr
This function is a wrapper around the \code{\link[SpatialPosition:quickStewart]{quickStewart}} function in 
\code{\link[SpatialPosition]{SpatialPosition}} package.\cr \cr
The SpatialPosition package also provides: \itemize{
\item{vignettes to explain the computation of potentials;} 
\item{more customizable inputs and outputs (custom distance matrix, raster output...);}
\item{other functions related to spatial interactions (Reilly  and Huff catchment areas).}}
}
\details{
If var2 is provided the ratio between the potentials of var (numerator) 
and var2 (denominator) is computed.
}
\examples{
library(sf)
mtq <- st_read(system.file("shape/martinique.shp", package="cartography"))
smoothLayer(x = mtq, var = 'P13_POP',
            span = 4000, beta = 2, breaks = c(0,5000,seq(10000,110000,10000)),
            mask = mtq, border = NA,
            col = carto.pal(pal1 = 'wine.pal', n1 = 12),
            legend.title.txt = "Population\\nPotential",
            legend.pos = "topright", legend.values.rnd = -2)
propSymbolsLayer(x = mtq, var = "P13_POP", legend.pos = c(690000, 1599950),
                 legend.title.txt = "Population 2013",
                 col = NA, border = "#ffffff50")
layoutLayer(title = "Actual and Potential Popultation in Martinique", 
            author = "INSEE, 2016", sources = "")

\donttest{
library(sp)
data("nuts2006")
# Potential of GDP
smoothLayer(spdf = nuts3.spdf, df = nuts3.df,
            var = 'gdppps2008',
            span = 75000, beta = 2,
            mask = nuts0.spdf,
            legend.title.txt = "GDP",
            legend.pos = "topright", legend.values.rnd = -2)

# Potential of GDP per Capita
nuts3.df$gdppps2008 <- nuts3.df$gdppps2008 * 1000000
smoothLayer(spdf = nuts3.spdf, df = nuts3.df,
            var = 'gdppps2008', var2 = 'pop2008',
            span = 75000, beta = 2,
            mask = nuts0.spdf,
            legend.title.txt = "GDP PER CAPITA",
            legend.pos = "topright", legend.values.rnd = -2)
}
}
\seealso{
\link[SpatialPosition]{quickStewart}, \link[SpatialPosition]{SpatialPosition}, \link{choroLayer}
}
