% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getGridLayer.R
\name{getGridLayer}
\alias{getGridLayer}
\title{Build a Regular Grid Layer}
\usage{
getGridLayer(spdf, cellsize, type = "regular", spdfid = NULL)
}
\arguments{
\item{spdf}{a SpatialPolygonsDataFrame.}

\item{cellsize}{output cell size, in map units.}

\item{type}{shape of the cell, "regular" for squares, "hexagonal" for hexagons.}

\item{spdfid}{identifier field in spdf, default to the first column 
of the spdf data frame. (optional)}
}
\value{
A list is returned. The list contains "spdf": a SpatialPolygonsDataFrame of 
a regular grid and "df":  a data frame of surface intersection. df fields are id_cell: ids of the grid; 
id_geo: ids of the spdf and area_pct: share of the area of the polygon in the cell 
(a value of 55 means that 55\% of the spdf unit is within the cell).
}
\description{
Build a regular grid based on a SpatialPolygonsDataFrame. 
Provide also a table of surface intersections.
}
\examples{
\dontrun{
data(nuts2006)
# Get a grid layer
mygrid <- getGridLayer(spdf = nuts2.spdf, cellsize = 200000)
# Plot the grid
plot(mygrid$spdf)
head(mygrid$df)
       }
}
\seealso{
\link{getGridData}
}

