% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/palettes.R
\name{carto.pal}
\alias{carto.pal}
\title{Build Cartographic Palettes}
\usage{
carto.pal(pal1, n1, pal2 = NULL, n2 = NULL, middle = FALSE,
  transparency = FALSE)
}
\arguments{
\item{pal1}{name of the color gradiant (see Details).}

\item{n1}{number of colors (up to 20)}

\item{pal2}{name of the color gradiant (see Details).}

\item{n2}{number of colors (up to 20)}

\item{middle}{a logical value. If TRUE, a neutral color ("#F6F6F6", almost 
white) between 
two gradients is added.}

\item{transparency}{a logical value. If TRUE, contrasts are enhenced by 
adding an opacity variation.}
}
\value{
A vector of colors is returned.
}
\description{
Build sequantial, diverging and qualitative color palettes. 
Diververging color palettes can be dissymetric (different number of colors in 
each of the two gradients).
}
\details{
Sequential palettes: 
\itemize{
\item{blue.pal}
\item{orange.pal}
\item{red.pal}
\item{brown.pal}
\item{green.pal}
\item{purple.pal}
\item{pink.pal}
\item{wine.pal}
\item{grey.pal}
\item{turquoise.pal}
\item{sand.pal}
\item{taupe.pal}
\item{kaki.pal}
\item{harmo.pal}}
 
Qualitative palettes: 
\itemize{
\item{pastel.pal}
\item{multi.pal}
}
}
\note{
Use \link{display.carto.all} to show all palettes and use 
\link{display.carto.pal} to show one palette.
}
\examples{
# Simple gradient: blue
carto.pal(pal1 = "blue.pal" ,n1 = 20)

# Double gradient: blue & red
carto.pal(pal1 = "blue.pal", n1 = 10, pal2 = "red.pal", n2 = 10)

# Adding a neutral color
carto.pal(pal1 = "blue.pal", n1 = 10, pal2 = "red.pal", n2 = 10, middle = TRUE)

# Enhancing contrasts with transparency
carto.pal(pal1="blue.pal", n1 = 10, pal2 = "red.pal", n2 = 10, middle = TRUE,
          transparency = TRUE)

# The double gradient can be asymetric
carto.pal(pal1 = "blue.pal", n1 = 5, pal2 = "red.pal", n2 = 15, middle = TRUE,
          transparency = TRUE)

# Build and display a palette
mypal <- carto.pal(pal1 = "blue.pal", n1 = 5, pal2 = "red.pal", n2 = 15,
                   middle = TRUE, transparency = TRUE)
k <- length(mypal)
image(1:k, 1, as.matrix(1:k), col =mypal, xlab = paste(k," classes",sep=""),
      ylab = "", xaxt = "n", yaxt = "n",bty = "n")
}
\references{
Qualitative palettes were generated with "i want hue" 
(\url{http://tools.medialab.sciences-po.fr/iwanthue/}) by Mathieu Jacomy at 
the Sciences-Po Medialab.
}
\seealso{
\link{display.carto.pal}, \link{display.carto.all}, \link{carto.pal.info}
}

