% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/warp_features.R
\name{warp_features}
\alias{warp_features}
\title{Apply the deformation used to build a cartogram to a set of
simple geometry  coordinates}
\usage{
warp_features(sfgeom, carto, verbose = FALSE)
}
\arguments{
\item{sfgeom}{a sf or a sfc object which contains simple feature geometry of
types in the following \code{POINT}, \code{MULTIPOINT}, \code{LINESTRING},
\code{MULTILINESTRING}, \code{POLYGON}, `MULTIPOLYGON}

\item{carto}{a cartogramR object}

\item{verbose}{a boolean object to set on verbose mode (default to \code{FALSE})}
}
\value{
a sf or a sfc object which contains simple feature geometry transformed
}
\description{
Apply the deformation used to build a cartogram to a set of
simple geometry coordinates or simple features.
The resulting  simple geometry object can
be used to add geometry features on the cartogram.
}
\examples{
\donttest{
  data(usa)
  carto <- cartogramR(usa, "electors64")
  LA <- sf::st_sfc(sf::st_point(c(-118.243685, 34.052234)))
  sf::st_crs(LA) <- 4326
  moregeom <- warp_features(LA, carto)
  plot(carto)
  plot(moregeom, add=TRUE, col=2, pch=15)
}

}
